
DROP TABLE IF EXISTS `site_plugin_testimonials_cats`;
CREATE TABLE `site_plugin_testimonials_cats` (
  `cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `cat_order` int(11) NOT NULL,
  `cat_status` int(11) NOT NULL,
  `cat_size` varchar(5) NOT NULL,
  `cat_size_lg` varchar(5) NOT NULL,
  `cat_size_md` varchar(5) NOT NULL,
  `cat_size_sm` varchar(5) NOT NULL,
  `cat_size_xs` varchar(5) NOT NULL,
  `cat_css_details` varchar(255) NOT NULL,
  PRIMARY KEY (`cat_id`),
  KEY `module_id` (`module_id`,`cat_order`,`cat_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_testimonials_cats_lang`;
CREATE TABLE `site_plugin_testimonials_cats_lang` (
  `cat_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `cat_title` varchar(255) NOT NULL,
  `cat_description` text NOT NULL,
  KEY `cat_id` (`cat_id`,`module_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_testimonials_items`;
CREATE TABLE `site_plugin_testimonials_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_date` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_image` int(1) NOT NULL,
  `item_link` text NOT NULL,
  `item_cat` text NOT NULL,
  `item_link_type` int(1) NOT NULL,
  `item_link_module` int(11) NOT NULL,
  `item_link_global` int(11) NOT NULL,
  `item_link_target` varchar(20) NOT NULL,
  `item_link_rel` varchar(20) NOT NULL,
  `item_css_list` varchar(255) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `item_id` (`item_id`,`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_testimonials_items_lang`;
CREATE TABLE `site_plugin_testimonials_items_lang` (
  `item_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_name` varchar(255) NOT NULL,
  `item_position` varchar(255) NOT NULL,
  `item_company` varchar(255) NOT NULL,
  `item_body` text NOT NULL,
  `item_link_link` varchar(255) NOT NULL,
  KEY `item_id` (`item_id`,`module_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
